<div class="tab-pane show active" id="general">
<ul class="nav nav-tabs nav-bordered">
        @foreach(siteLanguages() as $key => $language)
            <li class="nav-item">
                <a href="#tab_{{ $key }}" data-toggle="tab" aria-expanded="false" class="nav-link {{ $key == 'ar' ? 'active' : '' }}"> {{ $language }} </a>
            </li>
        @endforeach

    </ul>
    <div class="tab-content">
        @foreach(siteLanguages() as $key => $language)
            <div class="tab-pane {{ $key == 'ar' ? 'active' : '' }}" id="tab_{{ $key }}">
                    <div class="form-group row mb-3">
                        <label for="bank_name[{{ $key }}]" class="col-md-3 col-form-label">اسم البنك:
                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-9">
                            {!! Form::text('bank_name['.$key.']', isset($bank) ? $bank->bank_name[$key] : null, ["parsley-trigger"=>"change", "required" ,'class'=> 'form-control', 'id'=> 'bank_name['.$key.']', 'placeholder'=> $language,  'maxlength'=> "100"]) !!}
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label for="name[{{ $key }}]" class="col-md-3 col-form-label">@lang('messages.name'):
                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-9">
                            {!! Form::textarea('name['.$key.']', isset($bank) ? $bank->name[$key] : null, ["parsley-trigger"=>"change", "required" ,'class'=> 'form-control', 'id'=> 'name['.$key.']', 'placeholder'=> $language]) !!}
                        </div>
                    </div>

            </div>

        @endforeach


    </div>
</div>

<div class="tab-pane" id="another">

    <div class="form-group row mb-3">
        <label class="col-md-3 col-form-label">@lang('messages.image'):
            <span class="text-danger">*</span>
        </label>
        <div class="col-9">
            <div class="fileinput fileinput-new" data-provides="fileinput">
                <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                    @if( isset($bank->image) )
                        <img src="{{ URL::asset('uploads/banks/'.$bank->image) }}">
                    @endif
                </div>
                <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="photo" accept="image/*" {{isset($bank->image) ? '' : ' parsley-trigger="change" required' }}>
                        </span>
                    <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row mb-3">
        <label for="account_number" class="col-md-3 col-form-label">@lang('messages.account_number'):
            <span class="text-danger">*</span>
        </label>
        <div class="col-9">

            <input type="text"  name="account_number" class="form-control" placeholder="{{trans('messages.account_number')}}" value="{{isset($bank) ? $bank->account_number : '' }}" parsley-trigger="change" required >

        </div>
    </div>


</div>
