@extends('admin.layouts.master')

@section('title')
    @lang('messages.view_all_contacts')
@endsection
@section('styles')

    <!-- Summernote css -->
    <link href="{{ URL::asset('admin/libs/summernote/summernote-bs4.css') }}" rel="stylesheet" />

@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.contacts.index') }}">@lang('messages.contacts')</a></li>
                        <li class="breadcrumb-item active">@lang('messages.contacts')</li>
                    </ol>
                </div>
                <h4 class="page-title">@lang('messages.view_all_contacts')</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-9">
        <div class="card-box">

                <div class="mt-4">


                    <hr/>

                    <div class="media mb-4 mt-1">
                        <div class="media-body">
                            <span class="float-right mb-2">{{$contact->created_at->format('Y-m-d g:i A')}}</span>
                            <h6 class="m-0 font-14 mb-2">@lang('messages.name'): {{$contact->name}}</h6>
                            <h6 class="m-0 font-14 mb-2">@lang('messages.phone'): {{$contact->phone}}</h6>
                            <small class="text-muted">@lang('messages.From'): {{$contact->email}}</small>
                        </div>
                    </div>
                    <div class="media mb-4 mt-1">
                        <div class="media-body">
                            <small class="m-0 font-14 mb-2">@lang('messages.message')</small>
                        </div>
                    </div>

                    <p>{{$contact->message}}</p>
                    <hr/>

                    <h4>@lang('messages.reply_on_message')</h4>
                    <p>{{$contact->reply ? $contact->reply : '---'}}</p>
                    <hr/>


                </div> <!-- card-box -->
                @if(!$contact->reply)
                <form action="{{route('admin.contacts.reply', $contact->id)}}" method="post" class="form-horizontal form-row-seperated parsley-examples">
                    @csrf
                <div class="media mb-0 mt-5">
                    <img class="d-flex mr-3 rounded-circle avatar-sm" src="{{ URL::asset('admin/images/logo.png')}}" alt="Generic placeholder image">
                    <div class="media-body">
                        <div >
                            <textarea id="message_reply" name="msg_body" class="form-control autosizeme" rows="13" cols="100" placeholder="نص الرسالة" parsley-trigger="change" required></textarea>

                        </div> <!-- end reply-box -->
                    </div> <!-- end media-body -->
                </div> <!-- end medi-->

                <div class="text-right mt-5">
                    <button type="submit" class="btn btn-primary btn-rounded width-sm">@lang('messages.send')</button>
                </div>

                </form>
                @endif



        </div>
        </div>

    </div>


@endsection
@section('scripts')
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <!--Summernote js-->
    <script src="{{ URL::asset('admin/libs/summernote/summernote-bs4.min.js') }}"></script>

    <script src="{{ URL::asset('admin/js/pages/email-summernote.init.js') }}"></script>
    <script>
        $('body').addClass('page-container-bg-solid');
    </script>
@endsection
