@extends('admin.layouts.master')

@section('title')
    اضافة المنتجات
@endsection

@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/jquery-nice-select/nice-select.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />

    <style>
        .select2-container .select2-selection--multiple .select2-selection__rendered {
            width: 544px;
        }

        .header-title{
            font-size: large;
            font-weight: bold;
        }

    </style>
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.products.index') }}">المنتجات</a></li>
                        <li class="breadcrumb-item active">اضافة المنتجات</li>
                    </ol>
                </div>
                <h4 class="page-title">اضافة المنتجات</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::open([ 'url' => route('admin.products.store'), 'class' => 'form-horizontal form-row-seperated parsley-examples', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">معلومات المنتجات</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit"  >
                        @lang('messages.save')
                    </button>
                </div>

                <ul class="nav nav-tabs nav-bordered">
                    <li class="nav-item">
                        <a href="#general" data-toggle="tab" aria-expanded="false" class="nav-link active">
                            @lang('messages.general')
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#another" data-toggle="tab" aria-expanded="true" class="nav-link">
                            @lang('messages.another')
                        </a>
                    </li>

                </ul>
                <div class="card-box">
                    <div class="tab-content">
                        @include('admin.products._form')


                    </div>
                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/jquery-nice-select/jquery.nice-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-maxlength/bootstrap-maxlength.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-advanced.init.js') }}"></script>
    <script type="text/javascript" src="//code.jquery.com/ui/1.12.1/jquery-ui.js" ></script>

    <script type="text/javascript" src="//cdn.datatables.net/v/dt/dt-1.10.12/datatables.min.js"></script>
    <script src="{{ URL::asset('admin/js/tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jquery-tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/summernote-custom.js') }}"></script>


    <script>
        $(document).ready(function () {
            var yourArray=[];
            $('select[name="category_id"]').on('change', function() {
                var id = $(this).val();

                if(id == ''){
                    $('#subCategory').empty();

                }else{
                    $.ajax({
                        url: '/get/subCategories/'+id,
                        type: "GET",
                        dataType: "json",
                        success:function(data) {

                            if(data['categories'].length > 0){
                                $('#subCategory').empty();

                                $('#subCategory').append('<div class="form-group row mb-3"> <label for="attribute" class="col-md-3 col-form-label">الاقسام الفرعية <span class="text-danger">*</span> </label><div class="col-9"><select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="sub_category_id" name="sub_category_id"  parsley-trigger="change" required >');
                                $('select[name="sub_category_id"]').append('<option value> اختر</option>');
                                $.each(data['categories'], function(index , categories) {

                                    $('select[name="sub_category_id"]').append('<option value="'+ categories.id +'">'+ categories.name +'</option>');

                                });
                                $('#subCategory').append(' </select></div></div>');
                                $('.selectpicker').selectpicker('refresh');

                            }else{
                                $('#subCategory').empty();


                            }


                        }
                    });

                }



            });



        });

    </script>
@endsection
