<div class="tab-pane show active" id="general">
<ul class="nav nav-tabs nav-bordered">
        @foreach(siteLanguages() as $key => $language)
            <li class="nav-item">
                <a href="#tab_{{ $key }}" data-toggle="tab" aria-expanded="false" class="nav-link {{ $key == 'ar' ? 'active' : '' }}"> {{ $language }} </a>
            </li>
        @endforeach

    </ul>
    <div class="tab-content">
        @foreach(siteLanguages() as $key => $language)
            <div class="tab-pane {{ $key == 'ar' ? 'active' : '' }}" id="tab_{{ $key }}">
                    <div class="form-group row mb-3">
                        <label for="name[{{ $key }}]" class="col-md-3 col-form-label">@lang('messages.name'):
                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-9">
                            {!! Form::text('name['.$key.']', isset($region) ? $region->name[$key] : null, ["parsley-trigger"=>"change", "required" ,'class'=> 'form-control', 'id'=> 'name['.$key.']', 'placeholder'=> $language,  'maxlength'=> "100"]) !!}
                        </div>
                    </div>


            </div>

        @endforeach


    </div>
</div>

<div class="tab-pane" id="another">
    <div class="form-group row mb-3">
        <label for="city_id" class="col-md-3 col-form-label">المدن
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="city_id" name="city_id" parsley-trigger="change" required >
                <option value>المدن</option>
                @foreach( $cities as $data)
                    <option value="{{ $data->id }}" {{ isset($region) ?( $region->parent_id == $data->id ? "selected" : '') : (old("city_id") == $data->id ? "selected" : "" ) }}>{{ $data->name[App::getLocale()] }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="form-group row mb-3">
        <label for="shipping_cost" class="col-md-3 col-form-label">تكلفة التوصيل:
            <span class="text-danger">*</span>
        </label>
        <div class="col-9">

            <input type="text"  name="shipping_cost" class="form-control" placeholder="تكلفة التوصيل" value="{{isset($region) ? $region->shipping_cost : '' }}" parsley-trigger="change" required >

        </div>
    </div>

</div>
