@extends('admin.layouts.master')

@section('title')
    @lang('messages.subscriptions')
@endsection
@section('styles')

    <!-- Summernote css -->
    <link href="{{ URL::asset('admin/libs/summernote/summernote-bs4.css') }}" rel="stylesheet" />

@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.subscriptions.index') }}">@lang('messages.subscriptions')</a></li>
                        <li class="breadcrumb-item active"> @lang('messages.subscriptions')</li>
                    </ol>
                </div>
                <h4 class="page-title">@lang('messages.view_all_subscriptions')</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-9">
        <div class="card-box">

                <div class="mt-4">


                    <hr/>

                    <div class="media mb-4 mt-1">
                        <div class="media-body">
                            <span class="float-right mb-2">{{$subscription->created_at->format('Y-m-d g:i A')}}</span>
                            <small class="text-muted">@lang('messages.From'): {{$subscription->email}}</small>
                        </div>
                    </div>
                    <div class="media mb-4 mt-1">
                        <div class="media-body">
                            <small class="m-0 font-14 mb-2">@lang('messages.message')</small>
                        </div>
                    </div>
                    <hr/>


                </div> <!-- card-box -->

                <form action="{{route('admin.subscriptions.reply', $subscription->id)}}" method="post" class="form-horizontal form-row-seperated parsley-examples">
                    @csrf
                <div class="media mb-0 mt-5">
                    <img class="d-flex mr-3 rounded-circle avatar-sm" src="{{ URL::asset('admin/images/logo.png')}}" alt="Generic placeholder image">
                    <div class="media-body">
                        <div >
                            <input id="subject" name="subject" class="form-control autosizeme"  placeholder=" موضوع الرسالة" parsley-trigger="change" required />

                        </div> <!-- end reply-box -->
                    </div> <!-- end media-body -->
                </div> <!-- end medi-->
                <div class="media mb-0 mt-5">
                    <img class="d-flex mr-3 rounded-circle avatar-sm" src="{{ URL::asset('admin/images/logo.png')}}" alt="Generic placeholder image">
                    <div class="media-body">
                        <div >
                            <textarea id="message_reply" name="msg_body" class="form-control autosizeme" rows="13" cols="100" placeholder="نص الرسالة" parsley-trigger="change" required></textarea>

                        </div> <!-- end reply-box -->
                    </div> <!-- end media-body -->
                </div> <!-- end medi-->

                <div class="text-right mt-5">
                    <button type="submit" class="btn btn-primary btn-rounded width-sm">@lang('messages.send')</button>
                </div>

                </form>




        </div>
        </div>

    </div>


@endsection
@section('scripts')
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <!--Summernote js-->
    <script src="{{ URL::asset('admin/libs/summernote/summernote-bs4.min.js') }}"></script>

    <script src="{{ URL::asset('admin/js/pages/email-summernote.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jquery-tiny-custom.js') }}"></script>

    <script>
        $('body').addClass('page-container-bg-solid');

        tinymce.init({
            selector: '#message_reply',
            // width: 1000,
            height: 1000,
            // plugins: [
            //     'advlist autolink link image lists  print preview hr anchor pagebreak spellchecker',
            //     'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking',
            //     'table emoticons template paste help image media link tinydrive code imagetools'
            // ],
            tinydrive_token_provider: '/website/js/jwt.php',
//
//     // plugins: 'image media link tinydrive code imagetools',
//     toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify |' +
//         ' bullist numlist outdent indent | link image | print preview media fullpage | ' +
//         'forecolor backcolor emoticons | help',
//     menu: {
//         favs: {title: 'My Favorites', items: 'code visualaid | searchreplace | spellchecker | emoticons'}
//     },
//     menubar: 'favs file edit view insert format tools table help',
// });
            convert_urls: false,
            statusbar: false,
            font_formats:'Andale Mono=andale mono,times; Arial=arial,helvetica,sans-serif; Arial Black=arial black,avant garde; Book Antiqua=book antiqua,palatino; Comic Sans MS=comic sans ms,sans-serif; Courier New=courier new,courier; Georgia=georgia,palatino; Helvetica=helvetica; Impact=impact,chicago; Symbol=symbol; Tahoma=tahoma,arial,helvetica,sans-serif; Terminal=terminal,monaco; Times New Roman=times new roman,times; Trebuchet MS=trebuchet ms,geneva; Verdana=verdana,geneva; Webdings=webdings; Wingdings=wingdings,zapf dingbats ;DinNextRegular',

            plugins: 'image code print preview fullpage  searchreplace autolink directionality  visualblocks visualchars fullscreen image link    table charmap hr pagebreak nonbreaking  toc insertdatetime advlist lists  wordcount   imagetools   textpattern media ',

            image_title: true,
            automatic_uploads: true,
            // images_upload_url: '{{url("/admin/upload")}}',
            file_picker_types: 'image',
            file_picker_callback: function(cb, value, meta) {

                var input = document.createElement('input');
                input.setAttribute('type', 'file');
                input.setAttribute('accept', 'image/*');

                input.onchange = function() {
                    var file = this.files[0];

                    var reader = new FileReader();
                    reader.readAsDataURL(file);
                    reader.onload = function () {
                        var id = 'blobid' + (new Date()).getTime();
                        var blobCache =  tinymce.activeEditor.editorUpload.blobCache;
                        var base64 = reader.result.split(',')[1];
                        var blobInfo = blobCache.create(id, file, base64);
                        blobCache.add(blobInfo);
                        cb(blobInfo.blobUri(), { title: file.name });
                    };
                };
                input.click();
            }
        });
    </script>
@endsection
