<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\BasicController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\PostController;
use App\Http\Controllers\Api\User\ProfileController;
use App\Http\Controllers\Api\User\HomeController;
use App\Http\Controllers\Api\User\ProductController;
use App\Http\Controllers\Api\User\CategoryController;
use App\Http\Controllers\Api\User\RateController;
use App\Http\Controllers\Api\User\ChatController;
use App\Http\Controllers\Api\User\FavoriteController;
use App\Http\Controllers\Api\User\PaymentController;
use App\Http\Controllers\Api\User\CartController;
use App\Http\Controllers\Api\User\BankController;
use App\Http\Controllers\Api\User\ProviderProfileController;
use App\Http\Controllers\Api\User\OrderController;
use App\Http\Controllers\Api\Dealer\GiftController;
use App\Http\Controllers\Api\User\AddressController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
Route::namespace('Api')->middleware('ApiLang')->group( function () {


    //check phone
    Route::post( '/check-phone', [AuthController::class,"check_phone"]);
    /*verified phone */
    Route::post( '/send-code', [AuthController::class,"send_code"]);
    Route::post( '/confirm-phone', [AuthController::class,"confirmPhone"]);
    Route::post( '/login', [AuthController::class,"login"]);
    Route::post( '/register', [AuthController::class,"register"]);
    Route::post( '/forget-password', [AuthController::class,"forgetPassword"]);
    Route::post( '/resend-code-forget-password', [AuthController::class,"resendCodeForgetPassword"]);
    Route::post( '/confirm-code-forget-password', [AuthController::class,"confirmCodeResetPassword"]);
    Route::post( '/reset-password', [AuthController::class,"resetPassword"]);

    Route::get( '/get-page/{type}', [ApiController::class,"getPage"]);
    Route::get( '/questions', [ApiController::class,"questions"]);
    Route::get( '/contact-details', [ContactController::class,"contact_details"]);
    Route::post( '/contact', [ContactController::class,"contactUs"]);
    Route::get( '/get-cities', [ApiController::class,"get_cities"]);
    Route::get( '/all-regions-cities', [ApiController::class,"all_regions_cities"]);
    Route::get( '/all-regions-cities-for-dealer', [ApiController::class,"all_regions_cities_for_dealer"]);
    Route::get( '/get-region/{id}', [ApiController::class,"get_region"]);
    Route::get( '/home', [HomeController::class,"home"]);
    Route::get( '/search-home', [HomeController::class,"search_home"]);
//    Route::get( '/products', [ProductController::class,"all_products"]);
    Route::get( '/categories', [CategoryController::class,"categories"]);
    Route::get( '/sub-categories/{id}', [CategoryController::class,"sub_categories"]);
    Route::get( '/all-products', [CategoryController::class,"all_products"]);
    Route::get( '/product-details/{id}', [ProductController::class,"product_details"]);
    Route::get( '/rates/{id}', [RateController::class,"rates"]);
    Route::get( '/all-posts', [PostController::class,"all_posts"]);
    Route::get( '/post-details/{id}', [PostController::class,"post_details"]);
    Route::get( '/get-comments/{id}', [PostController::class,"get_comments"]);
    // socket io
    Route::post( '/edit-gift', [GiftController::class,"edit_gift"]);
    Route::get( '/provider-profile-details/{id}', [ProviderProfileController::class,"provider_profile_details"]);
    Route::post( '/upload-file-for-chat', [ChatController::class,"uploadFileForChat"]);

    Route::group(['middleware' => 'jwt.verify'], function () {

        Route::post( '/logout', [AuthController::class,"logout"]);
        Route::get( '/profile', [ProfileController::class,"profile"]);
        Route::get( '/get-unread-message', [BasicController::class,"get_unread_message"]);
        Route::post( '/edit-profile', [ProfileController::class,"edit_profile"]);
        Route::post( '/change-password', [ProfileController::class,"changePassword"]);
        Route::post( '/change-phone', [ProfileController::class,"send_code_for_change_phone"]);
        Route::post( '/confirm-code-change-phone', [ProfileController::class,"confirmCodeChangePhone"]);
        Route::post( '/resend-code-change-phone', [ProfileController::class,"resendCodeChangePhone"]);
        Route::post( '/add-post', [PostController::class,"add_post"]);
        Route::post( '/get-post', [PostController::class,"get_posts"]);
        Route::post( '/edit-post', [PostController::class,"edit_posts"]);
        Route::get( '/get-posts', [PostController::class,"get_posts"]);
        Route::delete( '/delete-posts/{id}', [PostController::class,"delete_posts"]);

        Route::post( '/add-comment', [PostController::class,"add_comment"]);
        Route::delete( '/delete-comment/{id}', [PostController::class,"delete_comment"]);
        Route::post( '/add-address', [AddressController::class,"add_address"]);
        Route::post( '/edit-address', [AddressController::class,"edit_address"]);
        Route::post( '/toggle-default-address', [AddressController::class,"toggle_default_address"]);
        Route::delete( '/delete-address/{id}', [AddressController::class,"delete_address"]);
        Route::get( '/get-addresses', [AddressController::class,"get_addresses"]);
        Route::post( '/start-chat-order', [ChatController::class,"start_chat_order"]);
        Route::post( '/toggle-product-to-favorite', [FavoriteController::class,"toggle_product_to_favorite"]);
        Route::get( '/my-favorite', [FavoriteController::class,"my_favorites"]);
        Route::get( '/chat-details/{id}', [ChatController::class,"chat_details"]);
        Route::get( '/get-rooms', [ChatController::class,"get_rooms"]);
        Route::post( '/add-gift', [GiftController::class,"add_gift"]);
        Route::post( '/add-to-cart', [CartController::class,"add_to_cart"]);
        Route::post( '/add-to-different-product-cart', [CartController::class,"add_new_different_product_to_cart"]);
        Route::post( '/check-address', [CartController::class,"check_address"]);
        Route::get( '/get-carts', [CartController::class,"get_carts"]);
        Route::post( '/remove-from-cart', [CartController::class,"remove_from_cart"]);
        Route::get( '/payment-summary', [PaymentController::class,"payment_summary"]);
        Route::post( '/add-coupon', [PaymentController::class,"add_coupon"]);
        Route::post( '/add-order', [PaymentController::class,"add_order"]);
        Route::get( '/payment-methods', [PaymentController::class,"payment_methods"]);
        Route::get( '/banks', [BankController::class,"banks"]);
        Route::get( '/my-orders', [OrderController::class,"my_orders"]);
        Route::post( '/cancel-order', [OrderController::class,"cancel_order"]);
        Route::get( '/my-order-details/{id}', [OrderController::class,"my_order_details"]);
        Route::post( '/add-rate', [RateController::class,"add_rate"]);

        /*chats*/
        Route::post( '/disconnect-room', [ChatController::class,"disconnect_room"]);
        Route::post( '/send-message', [ChatController::class,"send_message"]);
        Route::post( '/connect-room', [ChatController::class,"connect_room"]);

        Route::get( '/list-notifications', [BasicController::class,"listNotifications"]);
        Route::delete( '/delete-notifications/{id}', [BasicController::class,"delete_Notifications"]);
        Route::delete( '/delete-all-notifications', [BasicController::class,"delete_all_Notifications"]);


        Route::namespace('Dealer')->group( function () {
            Route::get( '/dealer-profile', [App\Http\Controllers\Api\Dealer\ProfileController::class,"profile"]);
            Route::post( '/dealer-edit-profile', [App\Http\Controllers\Api\Dealer\ProfileController::class,"dealer_edit_profile"]);
            Route::get( '/dealer-orders', [App\Http\Controllers\Api\Dealer\OrderController::class,"my_orders"]);
            Route::get( '/dealer-order-details/{id}', [App\Http\Controllers\Api\Dealer\OrderController::class,"my_orders_details"]);
            Route::post( '/change-order-status', [App\Http\Controllers\Api\Dealer\OrderController::class,"change_order_status"]);
            Route::get( '/chat-from-order/{id}', [App\Http\Controllers\Api\Dealer\OrderController::class,"chat_from_order"]);
            Route::get( '/wallet', [App\Http\Controllers\Api\Dealer\WalletController::class,"wallet"]);
            Route::post( '/pull-request', [App\Http\Controllers\Api\Dealer\WalletController::class,"pull_request"]);
            Route::get( '/all-cities-regions', [App\Http\Controllers\Api\Dealer\RegionController::class,"all_region"]);
            Route::post( '/edit-cities-regions', [App\Http\Controllers\Api\Dealer\RegionController::class,"edit_cities_regions"]);

        });

    });





});
